library(imager)
library(matrixStats)
library(scales)
library(gtools)
library(inflection)

flatDirectory = '/Users/gfivash/Dropbox/Greg/Work/PhD/Thesis Chapters/Chapter 3 - Sediment hummocks/Data Chapter 3 submission/Figure 5 - oxygenation event/Oxygen drainage exp data/Data-Yue-20180731/E1/E1-flatone-2h vs 10h-0-100-jpg/'
hummockDirectory = '/Users/gfivash/Dropbox/Greg/Work/PhD/Thesis Chapters/Chapter 3 - Sediment hummocks/Data Chapter 3 submission/Figure 5 - oxygenation event/Oxygen drainage exp data/Data-Yue-20180731/E5/E5-hummock1cm-2h vs 10h-jpg/'
hollowDirectory = '/Users/gfivash/Dropbox/Greg/Work/PhD/Thesis Chapters/Chapter 3 - Sediment hummocks/Data Chapter 3 submission/Figure 5 - oxygenation event/Oxygen drainage exp data/Data-Yue-20180731/E6/E6-hollow1cm-2h vs 10h-jpg/'

inputDirectory = '/Volumes/Greg HD/Yue Oxygen data/Data-Yue-20180731/E1/E1-flatone-2h vs 10h-0-100-jpg/'

setwd(inputDirectory)

filelist = mixedsort(dir())
n_files = length(filelist)

# time settings
starttime = as.POSIXct('2018-06-20 17:36:00')
interval = 300#120  # 2min=120s between adjacent two images

oxygenDeclineRate_1 = rep(NA, times = n_files)
oxygenDeclineRate_2 = rep(NA, times = n_files)

i = 1
fileSeq = 1:n_files
for(i in fileSeq){
  
  #i = round(runif(n = 1, min = 700, max = length(filelist)))
  filename = filelist[i]
  
  # load images, grayscale, crop, convert class from image to matrix
  p = load.image(filename)
  p.g = grayscale(p)
  p.g.c = as.cimg(p.g[205:660,120:710, 1, 1])
  m = as.matrix(p.g.c)
  m = m*100
  
  # Convert pixel depth to cm
  depth = seq(0,6.24, length.out = dim(m)[2])# - sedimentSurfaceDepth.cm # depth in "cm"
  # Average oxygen values across pixel rows to generate profile
  oxygen.mean = colMeans(m)
  
  #Smooth out profile with moving window to find inflection point
  interval = 10
  oxygenWindow = c()
  depthWindow = c()
  for(i_window in 1:length(oxygen.mean)){
    start = i_window
    end = start + interval
    
    oxygenWindow[i_window] = mean(oxygen.mean[start:end], na.rm = T)
    depthWindow[i_window] = mean(depth[start:end], na.rm = T)
  }
  
  # Visualize profile
  # plot(depthWindow ~ oxygenWindow, type = 'l', ylim = c(6.24,0), xlim = c(0,100))
  # points(depth ~ oxygen.mean, pch = '.')
  
  # Find inflection point
  inflectionPoint = bese(depthWindow, oxygenWindow, index = 1)$iplast
  
  # Remove all points above inflection point
  filter = (depth > inflectionPoint)
  y = oxygen.mean[filter]
  x = depth[filter] - min(depth[filter])
  
  # Remove all points 0.4 cm below inflection point (improves fit by removing noisy low O2 concentrations)
  y = y[x < 0.4]
  x = x[x <  0.4]
  
  #Method 1:
  c = 1.4
  m1 = nls(y ~ exp(a + b*x) + c, start = list(a = 3.8, b = -3.5))
  oxygenDeclineRate_1[i] = summary(m1)$coefficients[2]
  
  #Method 2:
  m2 = nls(y ~ exp(a + b*x), start = list(a = 3.8, b = -3.5))
  oxygenDeclineRate_2[i] = summary(m2)$coefficients[2]
  
  print(paste(i,'/',length(filelist), sep = ' '))
}  

plot(oxygenDeclineRate_1 ~ oxygenDeclineRate_2, pch = '.', log = '')

#Smooth out profile with moving window to find inflection point
interval = 10
rateWindow = c()
timeWindow = c()
rate = -oxygenDeclineRate_2
time = 1:length(rate)
for(i_window in time){
  start = i_window
  end = start + interval
  
  rateWindow[i_window] = mean(rate[start:end], na.rm = T)
  timeWindow[i_window] = mean(time[start:end], na.rm = T)
}
plot(rate ~ time, pch = '.', ylim = c(0.1,6), log = 'y')
lines(rateWindow ~ timeWindow)

d = data.frame(rate, rateWindow)
setwd('/Users/gfivash/Desktop/')
write.csv(d, 'rateE1.csv', row.names = F)


